program main
  use constantes
  use subrotinas
  implicit none
  integer :: i
  real(8) :: x_fp, y_fp, y_problema
  real(8) :: x0, y0, x1, y1
  real(8) :: phi_aux=phi, theta_aux=theta
  real(8), dimension(:, :), allocatable :: rot_num
  integer, dimension(:), allocatable :: chaos

  open(1, file='fig8a-phase-space.dat', status='unknown')
  open(2, file='fig8b.dat', status='unknown')
  open(3, file='fig8a-sh.dat', status='unknown')  
  open(43, file='fig8a-twin3.dat', status='unknown')  
  open(44, file='fig8a-twin4.dat', status='unknown')  
  open(47, file='fig8a-twin7.dat', status='unknown')  
  open(333, file='fig8a-caos.dat', status='unknown') 
  open(3332, file='fig8a-caos2.dat', status='unknown')

  ! encontrar pontos fixos
  x_fp = 0.5d0
  if ((phi_aux/theta_aux-5.d0/4.d0) > 0.d0) then
    y_problema = sqrt(phi_aux/theta_aux-5.d0/4.d0)
  else
    y_problema = 100.d0
  end if
  call find_fixed_points(x_fp, y_problema, y_fp)
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  ! calcular numero de rotacao 
  call rot_num_profile_superconvergent_y(y_fp, x_fp, -1.6d0, 1.9d0, rot_num, 10000000, grid_rot, chaos)
  do i = 1, grid_rot
    write(2,*) rot_num(i, 1), rot_num(i, 2)
  end do
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  ! invariantes, ilha pf
  x0 = 0.5d0;  y0 = -1.26d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(1,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.5d0;  y0 = -1.433d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(1,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.5d0;  y0 = -1.6d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(1,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.5d0;  y0 = 0.6996d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(1,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.5d0;  y0 = 0.8262d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(1,*)x1, y1
    x0=x1;y0=y1
  end do

  ! curva shearless
  x0 = 0.5d0;    y0 = y_shearless 
  do i = 1, 100*n
    call mapa(x0, y0, x1, y1)
    write(3,*)x1, y1
    x0=x1;y0=y1
  end do

  ! twin 3
  x0 = 0.5d0;    y0 = 1.06d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(43,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.5d0;    y0 = 1.1d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(43,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 1.003d0;    y0 = -1.009d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(43,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 1.348d0;    y0 = -0.958d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(43,*)x1, y1
    x0=x1;y0=y1
  end do

  ! twin 4
  x0 = 0.5d0;    y0 = -0.371d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(44,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.5d0;    y0 = -0.437d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(44,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.906d0;    y0 = -0.079d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(44,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.86d0;    y0 = 0.024d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(44,*)x1, y1
    x0=x1;y0=y1
  end do

  ! twin 7
  x0 = 0.5d0;    y0 = 0.4119d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(47,*)x1, y1
    x0=x1;y0=y1
  end do
  x0 = 0.198d0;    y0 = -0.758d0
  do i = 1, n
    call mapa(x0, y0, x1, y1)
    write(47,*)x1, y1
    x0=x1;y0=y1
  end do

  ! caos 1
  x0 = 0.5d0;    y0 = 0.2d0
  do i = 1, n*10
    call mapa(x0, y0, x1, y1)
    write(333,*)x1, y1
    x0=x1;y0=y1
  end do

  ! caos 2
  x0 = 0.5d0;    y0 = -1d0
  do i = 1, n*10
    call mapa(x0, y0, x1, y1)
    write(3332,*)x1, y1
    x0=x1;y0=y1
  end do

end program
