program main
  use constantes
  use subrotinas
  implicit none
  integer :: k, status, ct
  real(8) :: theta, phi, theta_i, theta_f
  real(8) :: root
  real(8) :: y_i, y_f, x_sh, y_sh

  open(1, file='phi-4-unfiltered.dat', status='unknown')
  
  theta = theta_inicial
  
  y_i = -2.d0
  y_f = sin(theta)/(2.d0*(1.d0-cos(theta))) + 0.01d0
  
  loop_phi: do k = 2, grid_phi
    phi = phi_inicial + (phi_max - phi_inicial) * float(k - 1) / float(grid_phi - 1)  
    
    print*,"phi = ", phi
    
    theta_i = theta - 1d-1
    theta_f = theta + 1d-1
    
    ct = 0
    
    call bisection(theta_i, theta_f, root, status, phi, y_i, y_f, x_sh, y_sh)
    
    if (status == 1) then
     ct = ct + 1
     print*,"bisection failed phi = ", phi
     stop
     cycle
    end if   
    
    if (status == 0) then
     theta = root
     write(1,*) theta, phi, x_sh, y_sh
    end if
    
  end do loop_phi  
  
end program
