program main
  use constantes
  use subrotinas
  implicit none
  integer :: status, ct, ios, i
  real(8) :: theta, phi
  real(8) :: x_sh, y_sh
  real(8), allocatable :: dados(:,:) ! theta, phi, x_sh, y_sh
  real(8), allocatable :: dados_filtrados(:,:) ! n linha, theta, phi, status_slater

  open(1, file='phi-4-unfiltered.dat', status='old', action='read', iostat=ios)
  open(2, file='fig7phi-4.dat', status='unknown')  
  
  ct = 0
  
  do
    read(1, *, iostat=ios) theta, phi, x_sh, y_sh
    if (ios /= 0) exit
    ct = ct + 1
  end do
  
  allocate(dados(ct, 4))
  allocate(dados_filtrados(ct, 4))
  
  rewind(1)
  do i = 1, ct
    read(1, *, iostat=ios) dados(i,1), dados(i,2), dados(i,3), dados(i,4)
    if (ios /= 0) exit    
  end do 

  print*, 'filtering data' 
  !$omp parallel do default(firstprivate) shared(dados_filtrados) schedule(dynamic)
  do i = 1, ct
    print*,'progress: ',100.d0*dble(i)/dble(ct),'/100%'
    
    theta = dados(i, 1)
    phi = dados(i, 2)
    x_sh = dados(i, 3)
    y_sh = dados(i, 4)
    
    if (phi > 5.0) then
      ! filtrar com o criterio de slater
      call slater_condition(x_sh, y_sh, theta, phi, status)
    else
      status = 0
    end if
    
    !$omp critical
    dados_filtrados(i,1) = i
    dados_filtrados(i,2) = theta
    dados_filtrados(i,3) = phi
    dados_filtrados(i,4) = status
    !$omp end critical   
        
  end do
  !$omp end parallel do  
  
  loop_escrita: do i = 1, ct
    ! print*, int(dados_filtrados(i,1)), dados_filtrados(i,2), dados_filtrados(i,3), int(dados_filtrados(i,4))
    if ( int(dados_filtrados(i,4)) == 0 ) then
      write(2,*) dados_filtrados(i,2), dados_filtrados(i,3)
    else  
      ! print*, 'slater não satisfeito'
      exit loop_escrita
    end if  
  end do loop_escrita
  
end program
