program main
  use constantes
  use subrotinas
  implicit none
  integer :: i, k
  real(8) :: x_fp, y_fp, y, x, y_problema
  real(8) :: x0, y0, x1, y1
  real(8) :: phi_aux=phi, theta_aux=theta
  real(8) :: derivative_amplitude, percentage_tol = 0.001d0
  real(8) :: tol_discontinuity, delta_x, y_min2, y_max2
  logical, dimension(grid_rot) :: is_discontinuity   
  real(8), dimension(:, :), allocatable :: rot_num
  real(8), dimension(grid_rot) :: deriv1
  integer, dimension(:), allocatable :: chaos
  integer :: num_extrema, total_extrema, start_seg, end_seg

  open(1, file='fig6c-ps.dat', status='unknown')
  open(2, file='fig6d-rot.dat', status='unknown')
  open(3, file='fig6c-sh.dat', status='unknown')
  open(13, file='FPstable.dat', status='unknown')
  open(14, file='FPunstable.dat', status='unknown')
  open(20, file='fig6d-rot-min.dat', status='unknown')

  ! encontrar pontos fixos
  x_fp = 0.5d0
  if ((phi_aux/theta_aux-5.d0/4.d0) > 0.d0) then
    y_problema = sqrt(phi_aux/theta_aux-5.d0/4.d0)
  else
    y_problema = 100.d0
  end if
  call find_fixed_points(x_fp, y_problema, y_fp)
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  ! calcular numero de rotacao e derivada, separar em segmentos continuos
  call rot_num_profile_superconvergent_y(y_fp, x_fp, -2.d0, y_fp - 0.05d0, rot_num, iter_rot, grid_rot, chaos)
  delta_x = rot_num(2, 1) - rot_num(1, 1)
  call central_difference_derivative(rot_num(:, 2), grid_rot, delta_x, deriv1)

  do i = 1, grid_rot
    write(2,*) rot_num(i, 1), rot_num(i, 2)
  end do

  derivative_amplitude = maxval(deriv1) - minval(deriv1)
  tol_discontinuity = percentage_tol * derivative_amplitude 
  
  is_discontinuity = .false.
  do i = 2, grid_rot
    if ((abs(deriv1(i) - deriv1(i-1)) > tol_discontinuity) .or. chaos(i) == 1) then
      is_discontinuity(i) = .true.
      is_discontinuity(i-1) = .true.
    end if
  end do

  start_seg = 1
  total_extrema = 0

  do i = 2, grid_rot
    if (is_discontinuity(i)) then
      if (i > start_seg) then
        end_seg = i - 1
        ! processar segmento de start_seg a end_seg
        call process_segment_y(start_seg, end_seg, deriv1, rot_num, num_extrema, y_fp)
        total_extrema = total_extrema + num_extrema
      end if
      start_seg = i + 1
    end if
  end do

  ! processar o ultimo segmento
  if (start_seg <= grid_rot) then
    end_seg = grid_rot
    call process_segment_y(start_seg, end_seg, deriv1, rot_num, num_extrema, y_fp)
    total_extrema = total_extrema + num_extrema
  end if
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  ! espaco de fases
  y_min2 = -2.d0; y_max2 = y_fp - 0.05d0
  !$omp parallel do default(firstprivate) schedule(dynamic)
    do k = 1, grid 

      x = x_fp
      y = y_min2 + (y_max2 - y_min2) * float(k - 1) / float(grid - 1)      
      
      x0 = x
      y0 = y
      
      write(1,*)x0, y0
      
      do i = 1, n
        call mapa(x0, y0, x1, y1)
        write(1,*)x1, y1
        x0=x1;y0=y1
      end do

    end do
  !$omp end parallel do

  ! condicoes iniciais adicionais
    x0 = -0.37d0;y0 = -0.062d0
    write(1,*)x0, y0
    do i = 1, n
      call mapa(x0, y0, x1, y1)
      write(1,*)x1, y1
      x0=x1;y0=y1
    end do

    x0 = -0.28d0;y0 = -0.04d0
    write(1,*)x0, y0
    do i = 1, n
      call mapa(x0, y0, x1, y1)
      write(1,*)x1, y1
      x0=x1;y0=y1
    end do

    x0 = -0.39d0;y0 = -0.062d0
    write(1,*)x0, y0
    do i = 1, n
      call mapa(x0, y0, x1, y1)
      write(1,*)x1, y1
      x0=x1;y0=y1
    end do

end program
