import numpy as np
import subprocess
import re
import os

n = 100  # You can choose the value of n
phi_values = np.linspace(0., 2*np.pi, n)

# Modify the 'parametros.f90' file
def modify_parametros_file(phi_value):
    with open('parametros.f90', 'r') as file:
        lines = file.readlines()

    for i, line in enumerate(lines):
        if re.match(r'\s*real\(8\), parameter :: phi =', line):
            lines[i] = f'real(8), parameter :: phi = {phi_value}\n'
            break

    with open('parametros.f90', 'w') as file:
        file.writelines(lines)

# Compile and execute the Fortran project
def compile_and_execute():
    subprocess.run(['python', 'compile.py'])

# Extract extrema values and write to output file
def extract_extrema_and_write_output(phi_value, output_file):
    with open('extremos.dat', 'r') as file:
        extrema_lines = file.readlines()

    if extrema_lines:
        with open(output_file, 'a') as file:
            for line in extrema_lines:
                y_coord = line.split()[1]
                file.write(f'{phi_value}  {y_coord}\n')
    else:
        print(f'No extrema found for phi_value: {phi_value}')

# Main script
output_file = 'fig5a.dat'

total_phi_values = len(phi_values)
for index, phi_value in enumerate(phi_values):
    modify_parametros_file(phi_value)
    
    # Clear the contents of 'extremos.dat' before each run
    open('extremos.dat', 'w').close()
    
    if os.path.exists('extremos.dat'):
        os.remove('extremos.dat')

    compile_and_execute()

    extract_extrema_and_write_output(phi_value, output_file)

    progress = ((index + 1) / total_phi_values) * 100
    print(f'Progress: {progress:.2f}%')