import numpy as np
import subprocess
import os
import re

n_theta = 500  
theta_values = np.linspace(0.1, 2 * np.pi-0.1, n_theta)

output_file = 'fig1a.dat'

# Ensure the output file is empty at the start
with open(output_file, 'w') as file:
    file.write('')

# Function to modify the 'parametros.f90' file
def modify_parametros_file(theta_value):
    with open('parametros.f90', 'r') as file:
        lines = file.readlines()

    for i, line in enumerate(lines):
        if re.match(r'\s*real\(8\), parameter :: theta =', line):
            lines[i] = f'real(8), parameter :: theta = {theta_value}\n'

    with open('parametros.f90', 'w') as file:
        file.writelines(lines)


def compile_and_execute():
    subprocess.run(['python', 'compile.py'])

def get_total_extrema():
    extrema_file = 'extremos.dat'
    if not os.path.exists(extrema_file):
        return 0

    with open(extrema_file, 'r') as file:
        lines = file.readlines()

    return len(lines)

def get_total_extrema_and_frequency():
    extrema_file = 'extremos.dat'
    if not os.path.exists(extrema_file):
        return 0, None

    with open(extrema_file, 'r') as file:
        lines = file.readlines()

    if len(lines) > 0:
        frequency = float(lines[0].split()[1])
        return len(lines), frequency
    return 0, None

# Main script
for theta_value in theta_values:
    print(f"Processing theta = {theta_value:.6f}")  

    # Modify the Fortran parameters
    modify_parametros_file(theta_value)

    # Clear the contents of 'extremos.dat' before each run
    open('extremos.dat', 'w').close()

    compile_and_execute()

    total_extrema, frequency = get_total_extrema_and_frequency()

    if total_extrema > 0 and frequency is not None:
        print(f"Found extrema with frequency = {frequency:.6f}")
        with open(output_file, 'a') as file:
            file.write(f'{theta_value:.12f}  {frequency:.6f}\n')